<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fonts', function (Blueprint $table) {
            $table->id();
            $table->string('font_name'); // CSS font name (font5, font6, etc.)
            $table->string('display_name'); // Human readable name
            $table->string('file_name'); // Original file name
            $table->string('file_path'); // Path to font file
            $table->text('style'); // Complete CSS style string
            $table->string('gender')->default('Unisex'); // Male, Female, Unisex
            $table->integer('font_size')->default(18); // Base font size
            $table->integer('top_position')->default(50); // Top position in px
            $table->integer('review_rating')->default(5); // Rating 1-5
            $table->boolean('is_active')->default(true); // Active status
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fonts');
    }
};
