<?php

namespace Database\Seeders;

use App\Models\OrderType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class OrderTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $orderTypes = [
            [
                'name' => 'Sale',
                'description' => 'Product or service sales orders',
                'color' => '#10B981', // Green
                'is_active' => true
            ],
            [
                'name' => 'Maintenance',
                'description' => 'Maintenance and technical support orders',
                'color' => '#F59E0B', // Yellow
                'is_active' => true
            ],
            [
                'name' => 'Installation',
                'description' => 'Equipment or software installation orders',
                'color' => '#3B82F6', // Blue
                'is_active' => true
            ],
            [
                'name' => 'Repair',
                'description' => 'Equipment repair orders',
                'color' => '#EF4444', // Red
                'is_active' => true
            ],
            [
                'name' => 'Consulting',
                'description' => 'Consulting service orders',
                'color' => '#8B5CF6', // Purple
                'is_active' => true
            ],
            [
                'name' => 'Development',
                'description' => 'Software development orders',
                'color' => '#06B6D4', // Cyan
                'is_active' => true
            ],
            [
                'name' => 'Training',
                'description' => 'Training and education orders',
                'color' => '#84CC16', // Lime green
                'is_active' => true
            ],
            [
                'name' => 'Audit',
                'description' => 'Audit and review orders',
                'color' => '#F97316', // Orange
                'is_active' => true
            ]
        ];

        foreach ($orderTypes as $type) {
            OrderType::create($type);
        }
    }
}
