<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Brand;

class BrandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $brands = [
            'Rolex',
            'Omega',
            'Cartier',
            'Patek Philippe',
            'Audemars Piguet',
            'Tag Heuer',
            'Breitling',
            'IWC',
            'Jaeger-LeCoultre',
            'Vacheron Constantin',
            'Hublot',
            'Panerai',
            'Tudor',
            'Longines',
            'Tissot',
            'Swatch',
            'Casio',
            'Seiko',
            'Citizen',
            'Fossil'
        ];

        foreach ($brands as $brandName) {
            Brand::create([
                'name' => $brandName,
                'description' => $brandName . ' watches',
                'is_active' => true
            ]);
        }
    }
}
