<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();
Route::get('/denied', ['as' => 'denied', function () {
    return view('404page');
}]);
Route::get('/letra', ['as' => 'letra', function () {
    return view("letra");
}]);

// Rutas públicas
Route::get('/preview/{layer}/{id}/{token}', 'App\Http\Controllers\AppController@preview');
Route::get('/previewall/{layer}/{id}/{color}/{page}/{token}', 'App\Http\Controllers\AppController@previewall');

// Aplicar middleware de timeout de sesión a todas las rutas autenticadas
Route::middleware(['auth',])->group(function () {
    Route::get('/', 'App\Http\Controllers\AppController@index')->name('App');
    Route::get('/home', 'App\Http\Controllers\AppController@home')->name('App');

    // API routes
    Route::post('/api/extend-session', 'App\Http\Controllers\Api\SessionController@extendSession');
    Route::get('/api/check-session', 'App\Http\Controllers\Api\SessionController@checkSession');

    Route::get('web/function/is_valid_token', 'App\Http\Controllers\Web\ClientsController@isValidToken');
    Route::get('/web/function/get_token_type', 'App\Http\Controllers\Web\ClientsController@getTokenType');
    Route::post('web/function/create_token', 'App\Http\Controllers\Web\ClientsController@createToken');
    Route::get('/web/function/getfonts', 'App\Http\Controllers\AppController@getFonts');

    //wizard Order
    Route::apiResource('/web/wizardorder', 'App\Http\Controllers\Web\WizardOrderController');
    Route::apiResource('/web/wizardimage', 'App\Http\Controllers\Web\WizardImageController');
    Route::post('/upload/images/store', 'App\Http\Controllers\UploadFileController@dropzoneFileUploadPost');
    Route::get('/upload/images', 'App\Http\Controllers\UploadFileController@dropzoneFileUploadPost');

    Route::post('web/function/sendLink', 'App\Http\Controllers\Web\WizardOrderController@sendSmsLink');
    Route::post('web/function/sendPreviewAllLink', 'App\Http\Controllers\Web\WizardOrderController@sendPreviewAllLink');
});
Route::post('web/function/sendSmsPreview', 'App\Http\Controllers\Web\WizardOrderController@sendSmsPreview');

Route::get('/wizard/fonts/', 'App\Http\Controllers\AppController@wizard')->middleware('token');

Route::get('/create', 'App\Http\Controllers\AppController@create');

/*Route::get('/dashboard', function () {
    return view('app');
})->middleware(['auth'])->name('dashboard');*/

require __DIR__ . '/auth.php';
